/**
* \file: IVideoOutAdapter.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2013-2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_IVIDEOOUTADAPTER_H
#define CARPLAY_IVIDEOOUTADAPTER_H

#include "IConfiguration.h"

namespace adit { namespace carplay
{

class FrameFragment
{
public:
    // frame data pointer; do not delete manually
    inline const void* GetData() const { return dataPtr; };
    // frame data length
    inline size_t GetLength() const { return length; };
    // some kime of timestamp, but the exact format is unclear for now
    inline uint64_t GetDisplayTime() const { return displayTime; };

protected:
    FrameFragment();
    virtual ~FrameFragment();

    const void* dataPtr;
    size_t      length;
    uint64_t    displayTime;
};

/**
 * Interface to be implemented by adapter.
 *
 * Thread-safety is guaranteed by CarPlay.
 */
class IVideoReceiver
{
public:
    /**
     * Register a callback to notify start of video playback
     */
    virtual void FirstFrameRendered() = 0;
};
class IVideoOutAdapter
{
public:
    enum Framerate
    {
        FRAMERATE_30 = 30,
        FRAMERATE_60 = 60,

        FRAMERATE_LAST = 0xffffffff
    };

    /**
     * Default virtual destructor.
     */
    virtual ~IVideoOutAdapter() {};

    /**
     * Initialize video out.
     *
     * \param [in] config       configuration
     * \param [in] width        video stream width
     * \param [in] height       video stream height
     * \param [in] framerate    video stream frame rate
     *
     * \return bool             false: if failed to initialize video out
     */
    virtual bool Initialize(const IConfiguration& config, int width, int height,
            Framerate framerate,IVideoReceiver &inReceiver, SessionId inSessionId) = 0;

    /**
     * Start video out stream.
     *
     * \return bool             false: if failed to start streaming
     */
    virtual bool Start() = 0;

    /**
     * Stop video out stream.
     */
    virtual void Stop() = 0;

    /**
     * Push a frame fragment.
     *
     * \param [in] fragment     H.264 fragment
     */
    virtual void Push(FrameFragment& fragment) = 0;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_IVIDEOOUTADAPTER_H */
